/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.ui.FileNames;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsOffsets;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UIObjectsReader
extends UIObjectProperties
implements UILog {
    private HashMap listeners;
    private Object listenersLock = new Object();
    private File objectsFile;
    private RandomAccessFile objectsReader;
    private UIObjectsOffsets recordOffsets;
    private File unacceptableFile;
    private File rootFile;
    private FileNames fileNames;
    private Set allowedShortIds;
    private static final String TRACE_MASKT = "HUIOBJRT";
    private static final String TRACE_MASKF = "HUIOBJRF";
    private static final String TRACE_MASKD = "HUIOBJRD";

    public UIObjectsReader() throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.UIObjectsReader()");
        this.fileNames = FileNames.getFileNames();
        this.objectsFile = new File(this.fileNames.getObjectsFileName());
        this.objectsReader = new RandomAccessFile(this.objectsFile, "rws");
        this.recordOffsets = new UIObjectsOffsets(this.objectsReader);
        this.unacceptableFile = new File(this.fileNames.getUnacceptableFileName());
        this.rootFile = new File(this.fileNames.getRootFileName());
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.UIObjectsReader()");
    }

    UIObjectsReader(Set allowedShortIds) throws IOException, HException {
        this();
        this.allowedShortIds = allowedShortIds;
    }

    public void close() {
        try {
            this.objectsReader.close();
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1797, ioexc).log();
        }
    }

    public Set getNoTargetRequiredTasks() {
        HashSet<String> result = new HashSet<String>();
        List consoleTasks = this.getAllConsoleTaskShortIds();
        Set ids = this.getShortIdsByType((byte)51);
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            try {
                String shortId = (String)iterator.next();
                if (UIObjectsReader.isTargetRequired(this.getBuffer(shortId)) || consoleTasks.contains(shortId)) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
            }
        }
        return result;
    }

    public Set getAllowedTasks(String shortId) {
        Trace.trace(TRACE_MASKT, "-> UIObjectsReader.getAllowedTasks()");
        byte[] buffer = this.getBuffer(shortId);
        boolean isManagedObject = UIObjectsReader.isManagedObject(buffer);
        if (!isManagedObject && !UIObjectsReader.isManagedObjectGroup(buffer)) {
            throw new IllegalArgumentException("Argument [" + shortId + "] passed to UIObjectReader.getAllowedTasks() does not represent not a managed object or managed object group.");
        }
        HashSet result = new HashSet();
        String fileName = null;
        try {
            if (isManagedObject) {
                fileName = this.fileNames.getAllowedTasksFileName(UIObjectsReader.getClassTypeShortId(buffer));
                File file = new File(fileName);
                if (file.exists()) {
                    this.parseFile(file, result, true);
                }
            } else {
                List leaves = this.getLeavesForGroup(shortId);
                Iterator iterator = leaves.iterator();
                while (iterator.hasNext()) {
                    buffer = this.getBuffer((String)iterator.next());
                    fileName = this.fileNames.getAllowedTasksFileName(UIObjectsReader.getClassTypeShortId(buffer));
                    File file = new File(fileName);
                    if (!file.exists()) continue;
                    this.parseFile(file, result, true);
                }
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1823, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKT, "<- UIObjectsReader.getAllowedTasks()");
        return result;
    }

    public synchronized List getTaskShortIdsForGroup(String taskGroupShortId, boolean returnSameMergedKey) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getTaskShortIdsForGroup(), group is " + taskGroupShortId);
        ArrayList result = new ArrayList();
        String fileName = null;
        try {
            List likeTaskGroups = this.getLikeTaskGroupShortIds(taskGroupShortId);
            ArrayList children = new ArrayList();
            Iterator iterator = likeTaskGroups.iterator();
            while (iterator.hasNext()) {
                fileName = this.fileNames.getTaskGroupFileName((String)iterator.next());
                File file = new File(fileName);
                this.parseFile(file, children, false);
            }
            this.getLeaves(children, result);
            if (!returnSameMergedKey) {
                HashMap<String, String> map = new HashMap<String, String>();
                int size = result.size();
                for (int i = 0; i < size; ++i) {
                    String shortId = (String)result.get(i);
                    try {
                        String mergedKey = UIObjectsReader.getMergedKey(this.getBuffer(shortId));
                        if (mergedKey == null) {
                            map.put(shortId, shortId);
                            continue;
                        }
                        map.put(mergedKey, shortId);
                        continue;
                    }
                    catch (InvalidIdException exc) {
                        Trace.trace(TRACE_MASKF, exc.toString());
                    }
                }
                result.clear();
                result.addAll(map.values());
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1799, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getTaskShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized List getChildrenShortIds(String parentShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getChildrenShortIds()");
        ArrayList result = new ArrayList();
        String fileName = this.fileNames.getManagedObjectGroupFileName(parentShortId);
        try {
            File file = new File(fileName);
            if (file.exists()) {
                this.parseFile(file, result, true);
            } else {
                List likeTaskGroups = this.getLikeTaskGroupShortIds(parentShortId);
                Iterator iterator = likeTaskGroups.iterator();
                while (iterator.hasNext()) {
                    fileName = this.fileNames.getTaskGroupFileName((String)iterator.next());
                    file = new File(fileName);
                    if (!file.exists()) continue;
                    this.parseFile(file, result, false);
                }
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1798, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getChildrenShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized List getLeavesForGroup(String groupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getLeavesForGroup(), group is " + groupShortId);
        ArrayList result = new ArrayList();
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(groupShortId);
        String fileName = null;
        try {
            this.getLeaves(groups, result);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1818, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getTaskShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getUnacceptableShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getUnacceptableShortIds()");
        HashSet result = new HashSet();
        try {
            this.parseFile(this.unacceptableFile, result, false);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1800, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getUnacceptableShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getUnacceptableManagedObjectShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getUnacceptableManagedObjectShortIds()");
        Set result = this.getShortIdsByType((byte)49, this.getUnacceptableShortIds());
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getUnacceptableManagedObjectShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getUnacceptableManagedObjectShortIdsForGroup(String groupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getUnacceptableManagedObjectShortIdsForGrou()");
        HashSet<String> result = new HashSet<String>();
        Set leaves = this.getShortIdsByType((byte)49, this.getLeavesForGroup(groupShortId));
        Set allUnacceptable = this.getUnacceptableShortIds();
        Iterator iterator = leaves.iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (!allUnacceptable.contains(next)) continue;
            result.add(next);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getUnacceptableManagedObjectShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getAttentionManagedObjectShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getAttentionManagedObjectShortIds()");
        HashSet<String> result = new HashSet<String>();
        Set managedObjects = this.getShortIdsByType((byte)49);
        Iterator iterator = managedObjects.iterator();
        while (iterator.hasNext()) {
            try {
                String shortId = (String)iterator.next();
                if (!UIObjectsReader.attentionsExist(this.getBuffer(shortId))) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getAttentionManagedObjectShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getAttentionManagedObjectShortIdsForGroup(String groupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getAttentionManagedObjectShortIdsForGroup()");
        HashSet<String> result = new HashSet<String>();
        Set leaves = this.getShortIdsByType((byte)49, this.getLeavesForGroup(groupShortId));
        Iterator iterator = leaves.iterator();
        while (iterator.hasNext()) {
            try {
                String shortId = (String)iterator.next();
                if (!UIObjectsReader.attentionsExist(this.getBuffer(shortId))) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getAttentionManagedObjectShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getShortIdsByType(byte type) {
        return this.getShortIdsByType(type, false);
    }

    public synchronized Set getShortIdsByType(byte type, Collection shortIds) {
        return this.getShortIdsByType(type, false, shortIds);
    }

    public synchronized Set getShortIdsByType(byte type, boolean deleted) {
        return this.getShortIdsByType(type, deleted, null);
    }

    public synchronized Set getShortIdsByType(byte type, boolean deleted, Collection shortIds) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getShortIdsByType()");
        HashSet<String> result = new HashSet<String>();
        try {
            int numRecords = (int)(this.objectsReader.length() / 770L);
            byte[] buffer = new byte[770];
            for (int i = 0; i < numRecords; ++i) {
                this.objectsReader.seek(i * 770);
                this.objectsReader.read(buffer, 0, 770);
                String shortId = UIObjectsReader.getShortId(buffer);
                if (!this.isAllowed(shortId) || !deleted && UIObjectsReader.isDeleted(buffer) || !UIObjectsReader.isMatchingType(buffer, type) || shortIds != null && !shortIds.contains(shortId)) continue;
                result.add(shortId);
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1810, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getShortIdsByType(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getRootManagedObjectShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getRootManagedObjectShortIds()");
        HashSet result = new HashSet();
        Set allRoots = this.getRootShortIdsFromFile();
        if (allRoots.size() > 0) {
            this.getTypes(allRoots, result, (byte)49);
            this.getTypes(allRoots, result, (byte)50);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getRootManagedObjectShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getRootManagedObjectGroupShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getRootManagedObjectGroupShortIds()");
        HashSet result = new HashSet();
        Set allRoots = this.getRootShortIdsFromFile();
        if (allRoots.size() > 0) {
            this.getTypes(allRoots, result, (byte)50);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getRootManagedObjectGroupShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getRootTaskGroupShortIds(boolean includeConsoleTasksGroup) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getRootTaskGroupShortIds()");
        Set result = new HashSet();
        Set allRoots = this.getRootShortIdsFromFile();
        if (allRoots.size() > 0) {
            this.getTypes(allRoots, result, (byte)52);
            if (!includeConsoleTasksGroup) {
                result.remove(this.findConsoleTasksGroupShortId(result));
            }
            result = this.removeLikeNames(result);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getRootTaskGroupShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized List getConsoleTaskShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getConsoleTaskShortIds()");
        ArrayList<String> result = new ArrayList<String>();
        String shortId = this.findConsoleTasksGroupShortId(this.getRootTaskGroupShortIds(true));
        if (shortId != null) {
            List children = this.getChildrenShortIds(shortId);
            Iterator iterator2 = children.iterator();
            while (iterator2.hasNext()) {
                String next = (String)iterator2.next();
                if (result.contains(next)) continue;
                result.add(next);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getConsoleTaskShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized List getAllConsoleTaskShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getAllConsoleTaskShortIds()");
        ArrayList result = new ArrayList();
        String shortId = this.findConsoleTasksGroupShortId(this.getRootTaskGroupShortIds(true));
        if (shortId != null) {
            this.addConsoleTasks(shortId, result);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getAllConsoleTaskShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized byte[] getBuffer(String shortId) throws InvalidIdException {
        return this.getBuffer(shortId, false);
    }

    public synchronized byte[] getBuffer(String shortId, boolean deleted) throws InvalidIdException {
        byte[] buffer;
        block8: {
            if (shortId == null) {
                throw new IllegalArgumentException("shortId argument passed to UIObjectsReader.getBuffer() is null");
            }
            buffer = null;
            try {
                if (this.isAllowed(shortId)) {
                    buffer = new byte[770];
                    int offset = this.recordOffsets.getOffset(shortId);
                    this.objectsReader.seek(offset + 0);
                    int numRead = this.objectsReader.read(buffer, 0, 770);
                    if (numRead != 770) {
                        throw new InvalidIdException("Could not read shortId " + shortId + ", should have read " + 770 + " bytes but only " + numRead + " bytes read.");
                    }
                    if (!deleted && buffer[8] == 84) {
                        throw new InvalidIdException("ShortId " + shortId + " has been deleted.");
                    }
                    break block8;
                }
                throw new InvalidIdException("ShortId " + shortId + " is not allowed in the current user context.");
            }
            catch (NumberFormatException nfexc) {
                InvalidIdException exc = new InvalidIdException("'Integer.parseInt(" + shortId + ",16)' threw exception " + nfexc);
                exc.printStackTrace();
                Trace.trace(TRACE_MASKF, exc.toString());
                throw exc;
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
                throw exc;
            }
            catch (Exception exc2) {
                InvalidIdException exc = new InvalidIdException("Could not read shortId " + shortId + ".  Exception is " + exc2);
                exc.printStackTrace();
                Trace.trace(TRACE_MASKF, exc.toString());
                throw exc;
            }
        }
        return buffer;
    }

    public boolean isValid(String shortId) {
        boolean result = false;
        try {
            byte[] buffer = this.getBuffer(shortId);
            result = true;
        }
        catch (InvalidIdException invalidIdException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKF, "<> UIObjectsReader.isValid(), result is " + result);
        return result;
    }

    public boolean isAllowed(String shortId) {
        return this.allowedShortIds == null || this.allowedShortIds.contains(shortId);
    }

    public synchronized Map getProperties(Collection shortIds, String[] propertyNames, Locale locale) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getProperties()");
        HashMap result = new HashMap();
        Iterator iterator = shortIds.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            try {
                byte[] buffer = this.getBuffer(shortId);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                result.put(shortId, properties);
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (propertyNames[i] == "Name") {
                        properties.put(propertyNames[i], UIObjectsReader.getLocalizedName(buffer, locale));
                        continue;
                    }
                    if (propertyNames[i] == "NameKey") {
                        properties.put(propertyNames[i], UIObjectsReader.getNameKey(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Caption") {
                        properties.put(propertyNames[i], UIObjectsReader.getLocalizedCaption(buffer, locale));
                        continue;
                    }
                    if (propertyNames[i] == "CaptionKey") {
                        properties.put(propertyNames[i], UIObjectsReader.getCaptionKey(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "ObjectIdNameKey") {
                        properties.put(propertyNames[i], UIObjectsReader.getObjectIdNameKey(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Status") {
                        properties.put(propertyNames[i], UIObjectsReader.getLocalizedStatusText(buffer, locale));
                        continue;
                    }
                    if (propertyNames[i] == "StatusShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getStatusShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Image") {
                        properties.put(propertyNames[i], UIObjectsReader.getImageName(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Type") {
                        properties.put(propertyNames[i], new Byte(UIObjectsReader.getType(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Root") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isRoot(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Busy") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isBusy(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Locked") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isLocked(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Acceptable") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isStatusAcceptable(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "AttentionsExist") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.attentionsExist(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "AttentionTaskShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getAttentionTaskShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "TargetRequired") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isTargetRequired(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "ClassTypeShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getClassTypeShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "OpenTaskShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getOpenTaskShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Disruptive") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isDisruptive(buffer)));
                        continue;
                    }
                    throw new IllegalArgumentException("Property name [" + propertyNames[i] + "] is not a valid property name.");
                }
            }
            catch (InvalidIdException exc) {
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getProperties()");
        return result;
    }

    public static String[] sortByName(Map properties) {
        String[] keys = properties.keySet().toArray(new String[properties.size()]);
        for (int i = 0; i < keys.length; ++i) {
            Map map = (Map)properties.get(keys[i]);
            String name1 = (String)map.get("Name");
            if (name1 == null) {
                name1 = " ";
                Trace.trace(TRACE_MASKF, "shortId " + keys[i] + " has a null name, changing to blank.");
            }
            for (int j = i + 1; j < keys.length; ++j) {
                map = (Map)properties.get(keys[j]);
                String name2 = (String)map.get("Name");
                if (name2 == null) {
                    name2 = " ";
                    Trace.trace(TRACE_MASKF, "shortId " + keys[i] + " has a null name, changing to blank.");
                }
                if (name2.compareToIgnoreCase(name1) >= 0) continue;
                String temp = keys[i];
                keys[i] = keys[j];
                keys[j] = temp;
                name1 = name2;
            }
        }
        return keys;
    }

    private Set getRootShortIdsFromFile() {
        HashSet allRoots = new HashSet();
        try {
            this.parseFile(this.rootFile, allRoots, true);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1801, ioexc).log();
        }
        return allRoots;
    }

    private void parseFile(File file, Collection list, boolean allowDuplicates) throws IOException {
        Trace.trace(TRACE_MASKD, "-> UIObjectsReader.parseFile(), file name is " + file.getAbsoluteFile());
        if (file.exists()) {
            char[] buffer = new char[(int)file.length()];
            FileReader reader = new FileReader(file);
            int numRead = reader.read(buffer);
            for (int i = 0; i < buffer.length; i += 9) {
                String shortId = new String(buffer, i, 8);
                if (this.isAllowed(shortId)) {
                    if (allowDuplicates) {
                        list.add(shortId);
                        continue;
                    }
                    if (list.contains(shortId)) continue;
                    list.add(shortId);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "shortId " + shortId + " is not allowed");
            }
            reader.close();
        } else {
            Trace.trace(TRACE_MASKD, "   file does not exist");
        }
        Trace.trace(TRACE_MASKD, "<- UIObjectsReader.parseFile()");
    }

    private Collection getTypes(Collection source, Collection result, byte type) {
        Trace.trace(TRACE_MASKF, "  find all objects with type " + type);
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            if (!this.isAllowed(shortId)) continue;
            try {
                if (!UIObjectsReader.isMatchingType(this.getBuffer(shortId), type)) continue;
                result.add(shortId);
                Trace.trace(TRACE_MASKF, "  found a matching type, shortId is " + shortId);
            }
            catch (InvalidIdException exc) {}
        }
        return result;
    }

    private Collection getLeaves(Collection shortIds, Collection result) throws IOException {
        Trace.trace(TRACE_MASKD, "-> UIObjectsReader.getLeaves()");
        Iterator iterator = shortIds.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            if (!this.isAllowed(shortId)) continue;
            try {
                if (UIObjectsReader.isGroup(this.getBuffer(shortId))) {
                    List groupMembers = this.getChildrenShortIds(shortId);
                    this.getLeaves(groupMembers, result);
                    continue;
                }
                result.add(shortId);
            }
            catch (InvalidIdException exc) {}
        }
        Trace.trace(TRACE_MASKD, "<- UIObjectsReader.getLeaves()");
        return result;
    }

    private String findConsoleTasksGroupShortId(Set rootTaskShortIds) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.findConsoleTasksGroupShortId()");
        String result = null;
        Iterator iterator = rootTaskShortIds.iterator();
        while (iterator.hasNext() && result == null) {
            String groupShortId = (String)iterator.next();
            if (!UIObjectsReader.isConsoleTaskGroup(this.getBuffer(groupShortId))) continue;
            Trace.trace(TRACE_MASKF, "   found a console tasks group, shortId is " + groupShortId);
            result = groupShortId;
        }
        if (result == null) {
            Trace.trace(TRACE_MASKF, "   could not find a console action group");
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.findConsoleTasksGroupShortId()");
        return result;
    }

    private byte[] findFirstTaskShortId(String groupShortId) {
        byte[] buffer = null;
        List children = this.getChildrenShortIds(groupShortId);
        Iterator iterator = children.iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String childShortId = (String)iterator.next();
            try {
                buffer = this.getBuffer(childShortId);
                if (UIObjectsReader.isTask(buffer)) {
                    found = true;
                    continue;
                }
                if (!UIObjectsReader.isTaskGroup(buffer) || (buffer = this.findFirstTaskShortId(childShortId)) == null) continue;
                found = true;
            }
            catch (InvalidIdException exc) {}
        }
        if (found) {
            return buffer;
        }
        return null;
    }

    private List getLikeTaskGroupShortIds(String taskGroupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getLikeTaskGroupShortIds()");
        ArrayList<String> result = new ArrayList<String>();
        try {
            byte[] buffer = this.getBuffer(taskGroupShortId);
            LocalizableText name = UIObjectsReader.getName(buffer);
            Trace.trace(TRACE_MASKF, "   LocalizableText is " + name);
            Set taskGroups = this.getShortIdsByType((byte)52);
            Iterator iterator = taskGroups.iterator();
            while (iterator.hasNext()) {
                String nextTaskGroup = (String)iterator.next();
                try {
                    buffer = this.getBuffer(nextTaskGroup);
                    LocalizableText nextName = UIObjectsReader.getName(buffer);
                    if (!name.equals(nextName)) continue;
                    Trace.trace(TRACE_MASKF, "   add next LocalizableText " + nextName);
                    result.add(nextTaskGroup);
                }
                catch (InvalidIdException exc) {}
            }
        }
        catch (InvalidIdException invalidIdException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getLikeTaskGroupShortIds(), number returned is " + result.size());
        return result;
    }

    private Set removeLikeNames(Set shortIds) {
        int i;
        String[] uniqueShortIds = new String[shortIds.size()];
        LocalizableText[] names = new LocalizableText[shortIds.size()];
        Iterator iterator = shortIds.iterator();
        int nextName = 0;
        while (iterator.hasNext()) {
            try {
                names[nextName] = null;
                uniqueShortIds[nextName] = (String)iterator.next();
                names[nextName] = UIObjectsReader.getName(this.getBuffer(uniqueShortIds[nextName]));
            }
            catch (InvalidIdException exc) {
                uniqueShortIds[nextName] = null;
            }
            ++nextName;
        }
        boolean removed = false;
        for (i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            for (int j = i + 1; j < names.length; ++j) {
                if (names[j] == null || !names[i].equals(names[j])) continue;
                uniqueShortIds[j] = null;
                names[j] = null;
                removed = true;
            }
        }
        if (removed) {
            shortIds.clear();
            for (i = 0; i < uniqueShortIds.length; ++i) {
                if (uniqueShortIds[i] == null) continue;
                shortIds.add(uniqueShortIds[i]);
            }
        }
        return shortIds;
    }

    private List addConsoleTasks(String consoleTasksGroupShortId, List result) {
        List children = this.getChildrenShortIds(consoleTasksGroupShortId);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            try {
                String next = (String)iterator.next();
                if (UIObjectsReader.isGroup(this.getBuffer(next))) {
                    this.addConsoleTasks(next, result);
                    continue;
                }
                if (result.contains(next)) continue;
                result.add(next);
            }
            catch (InvalidIdException exc) {}
        }
        return result;
    }
}

